/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import jclass.chart.ActionHandler;
import jclass.chart.ChartCanvas;
import jclass.chart.ChartDataView;
import jclass.chart.ChartDraw;
import jclass.chart.DepthHandler;
import jclass.chart.EditHandler;
import jclass.chart.EventTrigger;
import jclass.chart.Extents;
import jclass.chart.JCAboutBox;
import jclass.chart.JCAxis;
import jclass.chart.JCChart;
import jclass.chart.JCChartUtil;
import jclass.chart.JCDataIndex;
import jclass.chart.JCFillStyle;
import jclass.chart.JCMarker;
import jclass.chart.PlotArea;
import jclass.chart.RotateHandler;
import jclass.chart.TranslateHandler;
import jclass.chart.ZoomHandler;
import jclass.util.JCString;
import jclass.util.JCVector;

public class JCChartArea
extends ChartCanvas {
    JCVector xaxes = new JCVector();
    JCVector yaxes = new JCVector();
    int angleUnit = 1;
    JCVector markers = new JCVector();
    JCAxis horizActionAxis;
    JCAxis vertActionAxis;
    boolean axisBoundingBox = false;
    boolean fastAction = false;
    boolean inAction = false;
    int depth;
    int elevation;
    int rotation;
    transient ActionHandler handler;
    transient boolean saveDBState = false;
    private transient Hashtable drawables = new Hashtable();
    private PlotArea plotArea = new PlotArea(this);
    Rectangle plotRect = new Rectangle(0, 0, 0, 0);
    Rectangle total = new Rectangle(0, 0, 0, 0);
    int deltaX;
    int deltaY;
    boolean draw3D = false;
    boolean showReentrance;
    private boolean axisDrawOkay = false;
    private boolean inChanged = false;
    Graphics rbGC;
    boolean inSuperReshape = false;
    Point last = new Point(0, 0);
    private static JCString msg = null;

    public JCChartArea() {
        this.showBorder = false;
        this.enable11Events(60L);
        JCAxis h = new JCAxis(this, false, 0);
        h.name = "Default X";
        JCAxis v = new JCAxis(this, true, 0);
        v.name = "Default Y";
        this.xaxes.addElement(h);
        this.yaxes.addElement(v);
        this.setHorizActionAxis(h);
        this.setVertActionAxis(v);
    }

    public int getAngleUnit() {
        return this.angleUnit;
    }

    public synchronized void setAngleUnit(int unit) {
        if (!JCChartUtil.validUnit(unit)) {
            throw new IllegalArgumentException("Invalid value for AngleUnit.  Must be one of DEGREES, RADIANS or GRADS");
        }
        this.angleUnit = unit;
    }

    public JCMarker[] getMarkers() {
        if (this.markers == null || this.markers.size() == 0) {
            return null;
        }
        JCMarker[] mk = new JCMarker[this.markers.size()];
        int i = 0;
        while (i < mk.length) {
            mk[i] = (JCMarker)this.markers.elementAt(i);
            ++i;
        }
        return mk;
    }

    public JCMarker getMarker(int index) {
        JCMarker rval = null;
        try {
            rval = (JCMarker)this.markers.elementAt(index);
        }
        catch (Exception exception) {}
        return rval;
    }

    public JCAxis getXAxis(int index) {
        if (this.xaxes == null) {
            return null;
        }
        return (JCAxis)this.xaxes.elementAt(index);
    }

    public synchronized void setXAxis(int index, JCAxis ax) {
        if (ax == null) {
            if (index < 0 || index >= this.xaxes.size()) {
                throw new IllegalArgumentException("Invalid X axis index");
            }
            this.removeAxis(index, this.xaxes);
        } else {
            if (index < 0 || index > this.xaxes.size()) {
                throw new IllegalArgumentException("Invalid X axis index");
            }
            ax.setParent(this);
            this.addAxis(index, this.xaxes, ax);
        }
    }

    public synchronized void setXAxis(JCAxis[] ax) {
        this.xaxes = new JCVector();
        if (ax == null) {
            return;
        }
        int i = 0;
        while (i < ax.length) {
            if (ax[i] != null) {
                ax[i].setParent(this);
                ax[i].isVertical = false;
            }
            this.xaxes.setElementAt(i, ax[i]);
            ++i;
        }
    }

    public JCAxis[] getXAxis() {
        if (this.xaxes == null || this.xaxes.size() == 0) {
            return null;
        }
        JCAxis[] ret = new JCAxis[this.xaxes.size()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = (JCAxis)this.xaxes.elementAt(i);
            ++i;
        }
        return ret;
    }

    public JCAxis getYAxis(int index) {
        if (this.yaxes == null) {
            return null;
        }
        return (JCAxis)this.yaxes.elementAt(index);
    }

    public synchronized void setYAxis(int index, JCAxis ax) {
        if (ax == null) {
            if (index < 0 || index >= this.yaxes.size()) {
                throw new IllegalArgumentException("Invalid Y axis index");
            }
            this.removeAxis(index, this.yaxes);
        } else {
            if (index < 0 || index > this.yaxes.size()) {
                throw new IllegalArgumentException("Invalid Y axis index");
            }
            ax.setParent(this);
            this.addAxis(index, this.yaxes, ax);
        }
    }

    public synchronized void setYAxis(JCAxis[] ax) {
        this.yaxes = new JCVector();
        if (ax == null) {
            return;
        }
        int i = 0;
        while (i < ax.length) {
            if (ax[i] != null) {
                ax[i].setParent(this);
                ax[i].isVertical = true;
            }
            this.yaxes.setElementAt(i, ax[i]);
            ++i;
        }
    }

    public JCAxis[] getYAxis() {
        if (this.yaxes == null || this.yaxes.size() == 0) {
            return null;
        }
        JCAxis[] ret = new JCAxis[this.yaxes.size()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = (JCAxis)this.yaxes.elementAt(i);
            ++i;
        }
        return ret;
    }

    void removeAxis(int index, JCVector axes) {
        if (index < axes.size()) {
            axes.removeElementAt(index);
        }
    }

    void replaceAxis(int index, JCVector axes, JCAxis ax) {
        axes.setElementAt(ax, index);
    }

    void addAxis(int index, JCVector axes, JCAxis ax) {
        ax.setParent(this);
        axes.insertElementAt(ax, index);
    }

    public synchronized void setHorizActionAxis(JCAxis ax) {
        if (ax != null && (ax.isVertical || !this.xaxes.contains(ax) && !this.yaxes.contains(ax))) {
            throw new IllegalArgumentException("Invalid horizontal action axis");
        }
        this.horizActionAxis = ax;
    }

    public JCAxis getHorizActionAxis() {
        return this.horizActionAxis;
    }

    public synchronized void setVertActionAxis(JCAxis ax) {
        if (!(ax == null || ax.isVertical && (this.xaxes.contains(ax) || this.yaxes.contains(ax)))) {
            throw new IllegalArgumentException("Invalid vertical action axis");
        }
        this.vertActionAxis = ax;
    }

    public JCAxis getVertActionAxis() {
        return this.vertActionAxis;
    }

    public synchronized void setAxisBoundingBox(boolean bb) {
        if (bb == this.axisBoundingBox) {
            return;
        }
        this.axisBoundingBox = bb;
        this.setChanged(true);
    }

    public boolean getAxisBoundingBox() {
        return this.axisBoundingBox;
    }

    public boolean getFastAction() {
        return this.fastAction;
    }

    public synchronized void setFastAction(boolean fr) {
        if (fr == this.fastAction) {
            return;
        }
        this.fastAction = fr;
        this.setChanged(true);
    }

    public int getDepth() {
        return this.depth;
    }

    public synchronized void setDepth(int newDepth) {
        int tdepth = (int)JCChartUtil.clamp((double)newDepth, 0.0, 500.0);
        if (this.depth == tdepth) {
            return;
        }
        this.depth = tdepth;
        this.setChanged(true);
    }

    public int getElevation() {
        return this.elevation;
    }

    public synchronized void setElevation(int newElevation) {
        int televation = (int)JCChartUtil.clamp((double)newElevation, -45.0, 45.0);
        if (televation == this.elevation) {
            return;
        }
        this.elevation = televation;
        this.setChanged(true);
    }

    public int getRotation() {
        return this.rotation;
    }

    public synchronized void setRotation(int newRotation) {
        int trotation = (int)JCChartUtil.clamp((double)newRotation, -45.0, 45.0);
        if (trotation == this.rotation) {
            return;
        }
        this.rotation = trotation;
        this.setChanged(true);
    }

    public boolean getChanged() {
        return super.getChanged() || this.isDirty();
    }

    public void setReentrance(boolean nv) {
        this.showReentrance = nv;
    }

    public boolean getReentrance() {
        return this.showReentrance;
    }

    public void setChanged(boolean n) {
        if (this.inChanged && this.changed && n == this.changed) {
            System.out.println("ChartArea re-entrance.  Please report");
            if (this.showReentrance) {
                JCChartUtil.trace();
            }
            return;
        }
        if (this.chart == null) {
            return;
        }
        Object object = this.chart.getTreeLock();
        synchronized (object) {
            this.inChanged = n;
            this.ensureDrawables();
            Enumeration e = this.drawables.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                ChartDraw d = (ChartDraw)this.drawables.get(key);
                d.setChanged(true, false);
                if (n) continue;
                d.dataObject.setChanged(false, false);
            }
            this.changed = n;
            if (this.changed) {
                if (this.chart.getPeer() != null && !this.chart.getIsBatched()) {
                    if (this.sizeChanged()) {
                        this.updateParent();
                    } else {
                        this.recalc();
                        this.repaint();
                    }
                }
                this.inChanged = false;
                Object var3_8 = null;
                return;
            }
            int i = 0;
            while (i < this.xaxes.size()) {
                ((JCAxis)this.xaxes.elementAt(i)).setChanged(false, false);
                ++i;
            }
            int j = 0;
            while (j < this.yaxes.size()) {
                ((JCAxis)this.yaxes.elementAt(j)).setChanged(false, false);
                ++j;
            }
            this.inChanged = false;
        }
    }

    public PlotArea getPlotArea() {
        if (this.plotArea == null) {
            this.plotArea = new PlotArea(this);
        }
        return this.plotArea;
    }

    public synchronized void paintComponent(Graphics gc) {
        if (!this.isShowing) {
            return;
        }
        Graphics translatedGC = gc.create();
        super.paintComponent(translatedGC);
        Graphics tempGC = null;
        try {
            tempGC = this.clipForDrawing(translatedGC);
            this.drawBackplane(tempGC);
            if (JCChart.expired()) {
                this.drawExpired(gc);
                return;
            }
            if (this.axisDrawOkay) {
                Graphics localGC = this.clipToEntirePlotRect(translatedGC);
                if (!this.fastAction || !this.inAction) {
                    this.preDrawGrids(localGC, this.xaxes);
                    this.preDrawGrids(localGC, this.yaxes);
                }
                this.preDrawAxes(localGC, this.xaxes);
                this.preDrawAxes(localGC, this.yaxes);
                if (localGC != null) {
                    localGC.dispose();
                }
            }
            if (this.axisDrawOkay) {
                this.drawAxes(translatedGC, this.xaxes);
                this.drawAxes(translatedGC, this.yaxes);
                if (!this.fastAction || !this.inAction) {
                    this.drawAxisAnnotationsAndTitle(translatedGC, this.xaxes);
                    this.drawAxisAnnotationsAndTitle(translatedGC, this.yaxes);
                }
            }
            this.ensureDrawables();
            Enumeration e = this.drawables.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                ChartDraw d = (ChartDraw)this.drawables.get(key);
                d.draw(tempGC);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        if (tempGC != null) {
            tempGC.dispose();
        }
        if (translatedGC != null) {
            translatedGC.dispose();
        }
        this.rbGC = gc;
        if (this.handler != null) {
            this.handler.reanimate(this.last.x, this.last.y);
        }
        this.rbGC = null;
    }

    public Dimension preferredSize() {
        if (JCChart.expired()) {
            if (msg == null) {
                this.makeExpiredMessage();
            }
            Dimension sz = msg.getSize(this, this.getFont());
            this.ps.width = sz.width;
            this.ps.height = sz.height;
        } else if (this.ps != null || this.ps.width <= 0 || this.ps.height <= 0) {
            this.ps = super.preferredSize();
            this.ps.width = 100;
            this.ps.height = 100;
        }
        return new Dimension(this.ps);
    }

    public Dimension minimumSize() {
        return this.preferredSize();
    }

    public void recalc() {
        if (!this.isChanged()) {
            return;
        }
        if (this.size().width <= 0 || this.size().height <= 0) {
            return;
        }
        try {
            this.ensureDrawables();
            this.resetPlotArea();
            this.calc3D();
            this.calcLimits();
            this.calcAxisParams(this.xaxes);
            this.calcAxisParams(this.yaxes);
            if (!this.inAction || !this.fastAction) {
                this.calcAnchors(this.xaxes);
                this.calcAnchors(this.yaxes);
                this.makeAnnotations(this.xaxes);
                this.makeAnnotations(this.yaxes);
                this.calcAnnotationExtents(this.xaxes);
                this.calcAnnotationExtents(this.yaxes);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        this.layoutChartArea();
        if (this.checkDeltaValues()) {
            this.layoutChartArea();
        }
        this.calcGraphExtents();
        if (!this.inAction || !this.fastAction) {
            this.chart.updateChartLabels();
        }
        this.setChanged(false);
        this.needsRepaint = true;
    }

    public void layoutChartArea() {
        this.resetPlotArea();
        this.plotRect = new Rectangle(this.plotArea.left.value, this.plotArea.top.value, this.plotArea.right.value - this.plotArea.left.value, this.plotArea.bottom.value - this.plotArea.top.value);
        this.total = new Rectangle(this.plotArea.left.value, this.plotArea.top.value, this.plotArea.right.value - this.plotArea.left.value, this.plotArea.bottom.value - this.plotArea.top.value);
        JCVector vertAxes = new JCVector();
        JCVector horizAxes = new JCVector();
        this.getHorizVertAxes(horizAxes, vertAxes);
        this.adjustPlotRectForAxes(this.xaxes);
        this.adjustPlotRectForAxes(this.yaxes);
        this.layoutAxes(this.xaxes, false);
        this.layoutAxes(this.yaxes, false);
        this.adjustForExtents(horizAxes, vertAxes);
        this.layoutAxes(this.xaxes, true);
        this.layoutAxes(this.yaxes, true);
        this.layoutOrigins(this.xaxes);
        this.layoutOrigins(this.yaxes);
        this.adjustForOrthoExtents(horizAxes, vertAxes);
        if (!this.inAction || !this.fastAction) {
            this.layoutAnnotations(this.xaxes);
            this.layoutAnnotations(this.yaxes);
            this.checkAnnotations(this.xaxes);
            this.checkAnnotations(this.yaxes);
        }
        if (this.plotArea.top.isDefault) {
            this.plotArea.top.value = this.plotRect.y;
        }
        if (this.plotArea.left.isDefault) {
            this.plotArea.left.value = this.plotRect.x;
        }
        if (this.plotArea.bottom.isDefault) {
            this.plotArea.bottom.value = this.plotRect.y + this.plotRect.height;
        }
        if (this.plotArea.right.isDefault) {
            this.plotArea.right.value = this.plotRect.x + this.plotRect.width;
        }
    }

    public boolean isDirty() {
        this.ensureDrawables();
        Enumeration e = this.drawables.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            ChartDraw d = (ChartDraw)this.drawables.get(key);
            if (!d.dataObject.isChanged()) continue;
            return true;
        }
        int i = 0;
        while (i < this.xaxes.size()) {
            if (((JCAxis)this.xaxes.elementAt(i)).isChanged()) {
                return true;
            }
            ++i;
        }
        int j = 0;
        while (j < this.yaxes.size()) {
            if (((JCAxis)this.yaxes.elementAt(j)).isChanged()) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public void reshape(int x, int y, int w, int h) {
        if (x == this.location().x && y == this.location().y && w == this.size().width && h == this.size().height) {
            return;
        }
        this.inSuperReshape = true;
        super.reshape(x, y, w, h);
        this.inSuperReshape = false;
        this.changed = true;
        this.recalc();
        this.repaint();
    }

    public void repaint() {
        if (this.inSuperReshape) {
            return;
        }
        super.repaint();
    }

    public boolean mouseDrag(Event evt, int x, int y) {
        if (this.handler == null) {
            return super.mouseDrag(evt, x, y);
        }
        if (this.last.x == x && this.last.y == y) {
            return super.mouseDrag(evt, x, y);
        }
        this.last.x = x;
        this.last.y = y;
        this.handler.animate(x, y);
        return super.mouseDrag(evt, x, y);
    }

    public boolean mouseDown(Event evt, int x, int y) {
        if (this.chart == null) {
            return super.mouseDown(evt, x, y);
        }
        if (this.chart.url != null) {
            return super.mouseDown(evt, x, y);
        }
        EventTrigger et = this.chart.findMatchingTrigger(evt.modifiers);
        if (et == null) {
            return super.mouseDown(evt, x, y);
        }
        this.saveDBState = this.getDoubleBuffer();
        switch (et.action) {
            case 0: {
                this.handler = new RotateHandler(this);
                break;
            }
            case 1: {
                this.handler = new ZoomHandler(this);
                this.setDoubleBuffer(false);
                break;
            }
            case 2: {
                this.handler = new TranslateHandler(this);
                break;
            }
            case 5: {
                this.handler = new DepthHandler(this);
                break;
            }
            case 3: {
                this.handler = new EditHandler(this);
                this.setDoubleBuffer(false);
                break;
            }
            default: {
                this.handler = null;
            }
        }
        if (this.handler != null) {
            this.handler.start(x, y);
        }
        return super.mouseDown(evt, x, y);
    }

    public boolean mouseUp(Event evt, int x, int y) {
        if (this.handler == null) {
            return super.mouseUp(evt, x, y);
        }
        ActionHandler tmp = this.handler;
        this.handler = null;
        this.setDoubleBuffer(this.saveDBState);
        tmp.end(x, y);
        return super.mouseUp(evt, x, y);
    }

    public boolean keyDown(Event evt, int key) {
        if (key == this.chart.resetKey) {
            this.reset();
            return true;
        }
        if (key == this.chart.cancelKey) {
            this.cancel();
            return true;
        }
        return super.keyDown(evt, key);
    }

    void layoutAnnotations(JCVector axes) {
        if (axes == null) {
            return;
        }
        int i = 0;
        while (i < axes.size()) {
            JCAxis ax = (JCAxis)axes.elementAt(i);
            ax.layoutAnnotations();
            ++i;
        }
    }

    void addDrawable(ChartDataView dataObject) {
        if (dataObject == null) {
            return;
        }
        if (this.hasMatchingDrawable(dataObject)) {
            this.removeDrawable(dataObject);
        }
        ChartDraw dr = ChartDraw.makeDrawObject(dataObject);
        this.drawables.put(dataObject, dr);
    }

    void removeDrawable(ChartDataView dataObject) {
        if (dataObject == null) {
            return;
        }
        if (this.drawables != null) {
            this.drawables.remove(dataObject);
        }
    }

    boolean hasMatchingDrawable(ChartDataView dataObject) {
        if (this.drawables.containsKey(dataObject)) {
            ChartDraw d = (ChartDraw)this.drawables.get(dataObject);
            if (d.chartType == d.dataObject.getChartType()) {
                return true;
            }
        }
        return false;
    }

    ChartDraw getDrawable(ChartDataView dataObject) {
        ChartDraw ret = null;
        if (this.drawables.containsKey(dataObject)) {
            ChartDraw d = (ChartDraw)this.drawables.get(dataObject);
            if (d.chartType == d.dataObject.getChartType()) {
                ret = d;
            }
        }
        return ret;
    }

    void calcAnchors(JCVector axes) {
        if (axes == null) {
            return;
        }
        int i = 0;
        while (i < axes.size()) {
            JCAxis ax = (JCAxis)axes.elementAt(i);
            ax.calcAnchors();
            ++i;
        }
    }

    void calcLimits() {
        this.clearLimits();
        if (this.chart == null) {
            return;
        }
        int i = 0;
        while (i < this.chart.data.size()) {
            ChartDataView data = (ChartDataView)this.chart.data.elementAt(i);
            data.calcLimits();
            ++i;
        }
    }

    void clearLimits() {
        if (this.chart == null) {
            return;
        }
        int i = 0;
        while (i < this.chart.data.size()) {
            ChartDataView data = (ChartDataView)this.chart.data.elementAt(i);
            data.clearLimits();
            ++i;
        }
    }

    void cancel() {
        this.setDoubleBuffer(this.saveDBState);
        this.handler = null;
        this.inAction = false;
        this.setChanged(true);
    }

    void reset() {
        if (this.horizActionAxis != null) {
            this.horizActionAxis.min.isDefault = true;
            this.horizActionAxis.max.isDefault = true;
            this.horizActionAxis.setChanged(true, false);
            this.chart.sendEvent(this.horizActionAxis);
        }
        if (this.vertActionAxis != null) {
            this.vertActionAxis.min.isDefault = true;
            this.vertActionAxis.max.isDefault = true;
            this.vertActionAxis.setChanged(true, false);
            this.chart.sendEvent(this.vertActionAxis);
        }
        this.cancel();
    }

    void drawRubberBand(Point p, Point start) {
        Graphics gc;
        if (p == null) {
            return;
        }
        if (p.x == start.x || p.y == start.y) {
            return;
        }
        int ulx = start.x;
        int uly = start.y;
        int lrx = p.x;
        int lry = p.y;
        Graphics graphics = gc = this.rbGC == null ? this.getGraphics() : this.rbGC;
        if (lrx - ulx < 0) {
            int tempx = lrx;
            lrx = ulx;
            ulx = tempx;
        }
        if (lry - uly < 0) {
            int tempy = lry;
            lry = uly;
            uly = tempy;
        }
        gc.setXORMode(Color.white);
        gc.drawRect(ulx, uly, lrx - ulx, lry - uly);
        gc.setXORMode(Color.black);
        gc.drawRect(ulx + 1, uly + 1, lrx - ulx, lry - uly);
    }

    void drawRubberLine(Point start, Point end) {
        if (start == null || end == null) {
            return;
        }
        Graphics gc = this.getGraphics();
        gc.setXORMode(Color.white);
        gc.drawLine(start.x, start.y, end.x, end.y);
        gc.setXORMode(Color.black);
        gc.drawLine(start.x + 1, start.y + 1, end.x + 1, end.y + 1);
    }

    JCDataIndex pick(Point p, ChartDataView data, int focus) {
        JCDataIndex di = null;
        ChartDraw drawable = null;
        if (data != null) {
            drawable = this.getDrawable(data);
            if (drawable != null) {
                di = drawable.pick(p, focus == -1 ? data.pickFocus : focus);
            }
            if (di != null) {
                di.obj = this;
                di.dataView = data;
            }
            return di;
        }
        Enumeration e = this.drawables.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            ChartDraw d = (ChartDraw)this.drawables.get(key);
            JCDataIndex nd = d.pick(p, focus == -1 ? d.dataObject.pickFocus : focus);
            if (nd != null) {
                nd.obj = this;
                nd.dataView = d.dataObject;
            }
            if (di == null) {
                di = nd;
                continue;
            }
            if (nd == null || di.distance <= nd.distance) continue;
            di = nd;
        }
        return di;
    }

    boolean isXAxis(JCAxis ax) {
        return this.xaxes.contains(ax);
    }

    private void getHorizVertAxes(JCVector h, JCVector v) {
        int i = 0;
        while (i < this.xaxes.size()) {
            JCAxis ax = (JCAxis)this.xaxes.elementAt(i);
            if (ax.isVertical) {
                v.addElement(ax);
            } else {
                h.addElement(ax);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.yaxes.size()) {
            JCAxis ax = (JCAxis)this.yaxes.elementAt(i2);
            if (ax.isVertical) {
                v.addElement(ax);
            } else {
                h.addElement(ax);
            }
            ++i2;
        }
    }

    private void drawBackplane(Graphics gc) {
        if (this.chart == null) {
            return;
        }
        if (this.chart.data.size() == 1 && ((ChartDataView)this.chart.data.elementAt(0)).getChartType() == 11) {
            return;
        }
        JCFillStyle fs = new JCFillStyle(this.plotArea.getBackground(), 1);
        boolean isPolar = false;
        if (isPolar) {
            System.out.println("Polar backplane not implemented");
        } else {
            int x = this.plotRect.x;
            int y = this.plotRect.y;
            int width = this.plotRect.width;
            int height = this.plotRect.height;
            if (this.draw3D || this.axisBoundingBox) {
                if (this.draw3D && this.deltaX > 0) {
                    x += this.deltaX;
                }
                if (this.draw3D && this.deltaY > 0) {
                    y += this.deltaY;
                }
                width = Math.max(0, width - JCChartUtil.abs(this.deltaX));
                height = Math.max(0, height - JCChartUtil.abs(this.deltaY));
                fs.fillRect(gc, x, y, width, height);
                gc.setColor(this.plotArea.getForeground());
                gc.drawRect(x, y, width, height);
            } else {
                fs.fillRect(gc, x, y, width, height);
            }
        }
    }

    private void drawAxes(Graphics gc, JCVector axes) {
        if (axes == null) {
            return;
        }
        int i = 0;
        while (i < axes.size()) {
            JCAxis ax = (JCAxis)axes.elementAt(i);
            if (ax.isShowing) {
                ax.draw(gc);
            }
            ++i;
        }
    }

    private void drawAxisAnnotationsAndTitle(Graphics gc, JCVector axes) {
        if (axes == null) {
            return;
        }
        int i = 0;
        while (i < axes.size()) {
            JCAxis ax = (JCAxis)axes.elementAt(i);
            if (ax.isShowing) {
                ax.drawAnnotationsAndTitle(gc);
            }
            ++i;
        }
    }

    private void preDrawAxes(Graphics gc, JCVector axes) {
        if (axes == null) {
            return;
        }
        int i = 0;
        while (i < axes.size()) {
            JCAxis ax = (JCAxis)axes.elementAt(i);
            if (ax.isShowing) {
                ax.preDraw(gc);
            }
            ++i;
        }
    }

    private void preDrawGrids(Graphics gc, JCVector axes) {
        if (axes == null) {
            return;
        }
        int i = 0;
        while (i < axes.size()) {
            JCAxis ax = (JCAxis)axes.elementAt(i);
            if (ax.isShowing) {
                ax.drawGrid(gc);
            }
            ++i;
        }
    }

    private void adjustPlotRectForAxes(JCVector axes) {
        if (axes == null) {
            return;
        }
        int i = 0;
        while (i < axes.size()) {
            JCAxis ax = (JCAxis)axes.elementAt(i);
            ax.adjustPlotRect();
            ++i;
        }
    }

    private void layoutAxes(JCVector axes, boolean last) {
        if (axes == null) {
            return;
        }
        int i = 0;
        while (i < axes.size()) {
            JCAxis ax = (JCAxis)axes.elementAt(i);
            ax.layoutAxis(last);
            ++i;
        }
    }

    private void layoutOrigins(JCVector axes) {
        if (axes == null) {
            return;
        }
        int i = 0;
        while (i < axes.size()) {
            JCAxis ax = (JCAxis)axes.elementAt(i);
            ax.layoutOrigin();
            ++i;
        }
    }

    void checkAnnotations(JCVector axes) {
        if (axes == null) {
            return;
        }
        int i = 0;
        while (i < axes.size()) {
            JCAxis ax = (JCAxis)axes.elementAt(i);
            ax.checkAnnotations();
            ++i;
        }
    }

    private void ensureDrawables() {
        if (this.chart == null) {
            return;
        }
        if (this.drawables == null) {
            this.drawables = new Hashtable();
        }
        this.axisDrawOkay = false;
        int i = 0;
        while (i < this.chart.data.size()) {
            ChartDataView dv = (ChartDataView)this.chart.data.elementAt(i);
            if (!this.hasMatchingDrawable(dv)) {
                this.addDrawable(dv);
            }
            if (dv.getChartType() != 11) {
                this.axisDrawOkay = true;
            }
            ++i;
        }
    }

    private void calcAxisParams(JCVector axes) {
        if (axes == null) {
            return;
        }
        boolean hasRelated = false;
        int i = 0;
        while (i < axes.size()) {
            JCAxis ax = (JCAxis)axes.elementAt(i);
            if (ax.formula != null) {
                hasRelated = true;
            }
            ax.calcAxisParams(true);
            ++i;
        }
        if (!hasRelated) {
            return;
        }
        int i2 = 0;
        while (i2 < axes.size()) {
            JCAxis ax = (JCAxis)axes.elementAt(i2);
            if (ax.formula != null) {
                ax.formula.calcRelatedParams();
            }
            ++i2;
        }
    }

    private void makeAnnotations(JCVector axes) {
        if (axes == null) {
            return;
        }
        int i = 0;
        while (i < axes.size()) {
            JCAxis ax = (JCAxis)axes.elementAt(i);
            ax.makeAnnotations();
            ++i;
        }
    }

    private void calcAnnotationExtents(JCVector axes) {
        if (axes == null) {
            return;
        }
        int i = 0;
        while (i < axes.size()) {
            JCAxis ax = (JCAxis)axes.elementAt(i);
            ax.calcAnnotationExtents();
            ++i;
        }
    }

    private void calcGraphExtents() {
        Enumeration e = this.drawables.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            ChartDraw d = (ChartDraw)this.drawables.get(key);
            d.recalc();
        }
    }

    private void calcTransformation(JCVector axes) {
        if (axes == null) {
            return;
        }
        int i = 0;
        while (i < axes.size()) {
            JCAxis ax = (JCAxis)axes.elementAt(i);
            ax.calcTransformation();
            ++i;
        }
    }

    private void adjustForExtents(JCVector horizAxes, JCVector vertAxes) {
        Extents x = new Extents();
        Extents y = new Extents();
        this.findMaxExtents(horizAxes, x);
        this.findMaxExtents(vertAxes, y);
        int offset = x.minor - this.plotRect.x;
        if (offset > 0) {
            this.plotRect.width -= offset;
            this.plotRect.x += offset;
            this.adjust(horizAxes, offset, 0, -offset, 0);
            this.adjust(vertAxes, offset, 0, 0, 0, 1);
        }
        if ((offset = x.major - (this.total.width - this.plotRect.x - this.plotRect.width)) > 0) {
            this.plotRect.width -= offset;
            this.adjust(horizAxes, 0, 0, -offset, 0);
            this.adjust(vertAxes, -offset, 0, 0, 0, 2);
        }
        if ((offset = y.major - (this.total.height - this.plotRect.y - this.plotRect.height)) > 0) {
            this.plotRect.height -= offset;
            this.adjust(vertAxes, 0, -offset, 0, -offset);
            this.adjust(horizAxes, 0, -offset, 0, 0, 1);
        }
        if ((offset = y.minor - this.plotRect.y) > 0) {
            this.plotRect.y += offset;
            this.plotRect.height -= offset;
            this.adjust(vertAxes, 0, offset, 0, -offset);
            this.adjust(horizAxes, 0, offset, 0, 0, 2);
        }
    }

    private void adjustForOrthoExtents(JCVector horizAxes, JCVector vertAxes) {
        Rectangle old = new Rectangle(this.plotRect.x, this.plotRect.y, this.plotRect.width, this.plotRect.height);
        int i = 0;
        while (i < horizAxes.size()) {
            ((JCAxis)horizAxes.elementAt(i)).adjustForOrthoExtent();
            ++i;
        }
        int i2 = 0;
        while (i2 < vertAxes.size()) {
            ((JCAxis)vertAxes.elementAt(i2)).adjustForOrthoExtent();
            ++i2;
        }
        if (this.plotRect.equals(old)) {
            return;
        }
        this.adjust(vertAxes, 0, this.plotRect.y - old.y, 0, this.plotRect.height - old.height);
        this.adjust(horizAxes, this.plotRect.x - old.x, 0, this.plotRect.width - old.width, 0);
        this.layoutOrigins(horizAxes);
        this.layoutOrigins(vertAxes);
    }

    private void findMaxExtents(JCVector axes, Extents ex) {
        if (axes == null) {
            return;
        }
        int i = 0;
        while (i < axes.size()) {
            JCAxis ax = (JCAxis)axes.elementAt(i);
            Extents axex = ax.getExtents();
            if (axex != null) {
                if (axex.major > ex.major) {
                    ex.major = axex.major;
                }
                if (axex.minor > ex.minor) {
                    ex.minor = axex.minor;
                }
                if (axex.ortho > ex.ortho) {
                    ex.ortho = axex.ortho;
                }
            }
            ++i;
        }
    }

    private void adjust(JCVector axes, int x, int y, int w, int h) {
        this.adjust(axes, x, y, w, h, 0);
    }

    private void adjust(JCVector axes, int xoff, int yoff, int woff, int hoff, int condition) {
        if (axes == null) {
            return;
        }
        if (xoff == 0 && yoff == 0 && woff == 0 && hoff == 0) {
            return;
        }
        int i = 0;
        while (i < axes.size()) {
            JCAxis ax = (JCAxis)axes.elementAt(i);
            if (condition == 0 || condition == ax.getAdjustedRealPlacement()) {
                int x = ax.getLeft() + xoff;
                int y = ax.getTop() + yoff;
                int w = ax.getWidth() + woff;
                int h = ax.getHeight() + hoff;
                ax.reshape(x, y, w, h);
            }
            ++i;
        }
    }

    private void calc3D() {
        double nrotation = JCChartUtil.degToRad(this.rotation);
        double nelevation = JCChartUtil.degToRad(this.elevation);
        double sin_rotation = Math.sin(nrotation);
        double sin_elevation = Math.sin(nelevation);
        double cos_elevation = Math.cos(nelevation);
        double factor = (double)this.depth / 100.0;
        double dwidth = JCChartUtil.max(1.0, this.size().width);
        double depth = (dwidth /= 1.0 + JCChartUtil.abs(sin_rotation) * cos_elevation * factor) * factor;
        this.deltaX = (int)(depth * sin_rotation * cos_elevation);
        this.deltaY = (int)(-depth * sin_elevation);
        this.checkDeltaValues();
        boolean onlyPlot = true;
        ChartDataView[] cdv = ((JCChart)this.getParent()).getDataView();
        int i = 0;
        while (i < cdv.length) {
            if (cdv[i].getChartType() != 0 && cdv[i].getChartType() != 8) {
                onlyPlot = false;
            }
            ++i;
        }
        boolean deltas = this.deltaX != 0 || this.deltaY != 0;
        this.draw3D = !onlyPlot && deltas;
    }

    private boolean checkDeltaValues() {
        boolean chng = false;
        int wh = this.plotArea.right.value - this.plotArea.left.value;
        if (Math.abs(this.deltaX) > wh) {
            this.deltaX = this.deltaX < 0 ? -wh : wh;
            chng = true;
        }
        wh = this.plotArea.bottom.value - this.plotArea.top.value;
        if (Math.abs(this.deltaY) > wh) {
            this.deltaY = this.deltaY < 0 ? -wh : wh;
            chng = true;
        }
        return chng;
    }

    private Graphics clipToEntirePlotRect(Graphics gc) {
        Graphics tempGC = gc.create();
        tempGC.clipRect(this.plotRect.x, this.plotRect.y, this.plotRect.width + 1, this.plotRect.height + 1);
        return tempGC;
    }

    private Graphics clipForDrawing(Graphics gc) {
        Graphics tempGC = gc.create();
        int ps = 6;
        tempGC.clipRect(this.plotRect.x - ps / 2, this.plotRect.y - ps / 2, this.plotRect.width + 1 + ps, this.plotRect.height + 1 + ps);
        return tempGC;
    }

    private final void makeExpiredMessage() {
        Image im = JCAboutBox.makeKLImage(this);
        msg = JCString.parse(this, "This JClass Chart evaluation has expired.[NEWLINE]JClass Chart can be purchased from [HREF=http://www.klg.com]KL Group Inc.[/HREF][NEWLINE]");
        msg.add(im);
        msg.add(JCString.VERT_SPACE);
        msg.add(20);
        msg.add(JCString.NEWLINE);
        msg.add(new String("The leader in GUI components"));
    }

    private final void drawExpired(Graphics gc) {
        int y;
        Rectangle r = this.getDrawingArea();
        gc.drawRect(r.x + 1, r.y + 1, r.width - 2, r.height - 2);
        if (msg == null) {
            this.makeExpiredMessage();
        }
        Dimension sz = msg.getSize(this, this.getFont());
        r.y = y = r.y + (r.height - sz.height) / 2;
        msg.draw(this, gc, r, 1);
    }

    private void resetPlotArea() {
        Rectangle r = this.getDrawingArea();
        if (this.plotArea.top.isDefault) {
            this.plotArea.top.value = 0;
        }
        if (this.plotArea.left.isDefault) {
            this.plotArea.left.value = 0;
        }
        if (this.plotArea.bottom.isDefault) {
            this.plotArea.bottom.value = r.height;
        }
        if (this.plotArea.right.isDefault) {
            this.plotArea.right.value = r.width;
        }
    }
}

